#ifndef MTACHYONMATERIAL_H__
#define MTACHYONMATERIAL_H__

enum
{
	// temporary meta-data values
	TACHYON_MATERIAL_IS_UPGRADING = 900001,
	TACHYON_MATERIAL_DELAY_MAT_PREVIEW_UPDATE = 900002,

	//=============================================
	// Material groups
	//=============================================
	// Channel Main Groups
	TACHYON_MATERIALGROUP_COLOR = 10000,
	TACHYON_MATERIALGROUP_REFLECTANCE = 10040,
	TACHYON_MATERIALGROUP_TRANSPARENCY = 10060,
	TACHYON_MATERIALGROUP_BUMP = 10010,
	TACHYON_MATERIALGROUP_NORMAL = 10020,
	TACHYON_MATERIALGROUP_DISPLACEMENT = 10030,
	TACHYON_MATERIALGROUP_EMISSIVE = 10070,
	TACHYON_MATERIALGROUP_MASK = 10200,
	TACHYON_MATERIALGROUP_ENVIRONMENT = 10050, // deprecated

	// Channel Sub Groups
	TACHYON_MATERIALGROUP_SPECULARITY = 10080,
	TACHYON_MATERIALGROUP_GLOSSINESS = 10090,
	TACHYON_MATERIALGROUP_REFLECTANCE_REFLECTIONS = 10100,
	TACHYON_MATERIALGROUP_TRANSPARENCY_BLURRINESS = 10110,
	TACHYON_MATERIALGROUP_TRANSPARENCY_OPACITY = 10130,
	TACHYON_MATERIALGROUP_TRANSPARENCY_TRANSMISSION = 10140,
	TACHYON_MATERIALGROUP_ENVIRONMENT_OVERRIDE = 10120,

	TACHYON_MATERIALGROUP_FRESNEL_REFLECTANCE = 10150,
	TACHYON_MATERIALGROUP_METALNESS = 10160,

	TACHYON_MATERIALGROUP_CLEARCOAT = 10210,
	TACHYON_MATERIALGROUP_CLEARCOAT_GLOSSINESS = 10220,
	TACHYON_MATERIALGROUP_CLEARCOAT_NORMAL = 10230,


	//=============================================
	// Enable effect group
	//=============================================
	TACHYON_MATERIAL_USE_COLOR = 11000,
	TACHYON_MATERIAL_USE_BUMP = 11010,
	TACHYON_MATERIAL_USE_NORMAL = 11020,
	TACHYON_MATERIAL_USE_DISPLACEMENT = 11030,
	TACHYON_MATERIAL_USE_REFLECTANCE = 11040,
	TACHYON_MATERIAL_USE_ENVIRONMENT = 11050,
	TACHYON_MATERIAL_USE_TRANSPARENCY = 11060,
	TACHYON_MATERIAL_USE_EMISSIVE = 11070,
	TACHYON_MATERIAL_MAT_ID_COLOR = 11080,
	TACHYON_MATERIAL_USE_MASK = 11090,
	TACHYON_MATERIAL_USE_CLEARCOAT = 11100,

	//=============================================
	// Common declarations
	//=============================================
	TACHYON_MATERIAL_PREVIEW = 12000,
	TACHYON_MATERIAL_BUTTON_LIVE = 12010,
	TACHYON_MATERIAL_VERSION = 12020,

	TACHYON_MATERIAL_MIX_MODE_BLEND = 13000,
	TACHYON_MATERIAL_MIX_MODE_MULTIPLY = 13020,
	TACHYON_MATERIAL_MIX_MODE_ADD = 13010,
	TACHYON_MATERIAL_MIX_MODE_SUBTRACT = 13030,
	TACHYON_MATERIAL_PREVIEW_SCENE_ID = 13040,

	TACHYON_SHADER_RESOLUTION_LOW = 1,
	TACHYON_SHADER_RESOLUTION_MEDIUM = 2,
	TACHYON_SHADER_RESOLUTION_HIGH = 3,

	//=============================================
	// Properties of diffuse channel
	//=============================================
	TACHYON_MATERIAL_DIFFUSE_COLOR = 20000,

	// <diffuse shader>
	TACHYON_MATERIAL_DIFFUSE_SHADER_HREF = 20011,
	TACHYON_MATERIAL_DIFFUSE_SHADER_ANIM_ENABLED = 20012,
	TACHYON_MATERIAL_DIFFUSE_SHADER_RESOLUTION = 20013,
	TACHYON_MATERIAL_DIFFUSE_SHADER_USE_SRC_RES = 20014,
	TACHYON_MATERIAL_DIFFUSE_SHADER_RESOLUTION_TEXT = 20015,
	// </diffuse shader>

	TACHYON_MATERIAL_DIFFUSE_TEXTURE_MODE = 20020,
	TACHYON_MATERIAL_DIFFUSE_TEXTURE_STRENGTH = 20030,
	TACHYON_MATERIAL_DIFFUSE_TEXTURE_BRIGHTNESS = 20040,
	TACHYON_MATERIAL_DIFFUSE_TEXTURE_CONTRAST = 20050,
	TACHYON_MATERIAL_DIFFUSE_TEXTURE_GAMMA = 20060,
	TACHYON_MATERIAL_DIFFUSE_TEXTURE_INVERT = 20070,

	//=============================================
	// Properties of Reflectance - color
	//=============================================
	TACHYON_MATERIAL_REFLECTANCE_COLOR = 30000,

	TACHYON_MATERIAL_REFLECTANCE_PBR_WORKFLOW = 30001,
	TACHYON_MATERIAL_REFLECTANCE_PBR_WORKFLOW_METALLIC = 30002,
	TACHYON_MATERIAL_REFLECTANCE_PBR_WORKFLOW_SPECULAR = 30003,
	TACHYON_MATERIAL_REFLECTANCE_PBR_WORKFLOW_HYBRID = 30004,

	// <specular shader>
	TACHYON_MATERIAL_REFLECTANCE_SHADER_HREF = 30011,
	TACHYON_MATERIAL_REFLECTANCE_SHADER_ANIM_ENABLED = 30012,
	TACHYON_MATERIAL_REFLECTANCE_SHADER_RESOLUTION = 30013,
	TACHYON_MATERIAL_REFLECTANCE_SHADER_USE_SRC_RES = 30014,
	TACHYON_MATERIAL_REFLECTANCE_SHADER_RESOLUTION_TEXT = 30015,
	// </specular shader>

	TACHYON_MATERIAL_REFLECTANCE_TEXTURE_MODE = 30020,
	TACHYON_MATERIAL_REFLECTANCE_TEXTURE_STRENGTH = 30030,
	TACHYON_MATERIAL_REFLECTANCE_TEXTURE_BRIGHTNESS = 30040,
	TACHYON_MATERIAL_REFLECTANCE_TEXTURE_CONTRAST = 30050,
	TACHYON_MATERIAL_REFLECTANCE_TEXTURE_GAMMA = 30060,
	TACHYON_MATERIAL_REFLECTANCE_TEXTURE_INVERT = 30070,

	TACHYON_MATERIAL_REFLECTANCE_BRIGHTNESS = 30100,

	//=============================================
	// Properties of Reflectance - Metalness
	//=============================================

TACHYON_MATERIAL_REFLECTANCE_METALNESS_VALUE = 30110,
// <Metalness shader>
TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_HREF = 30111,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_ANIM_ENABLED = 30112,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_RESOLUTION = 30113,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_USE_SRC_RES = 30114,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_SHADER_RESOLUTION_TEXT = 30115,
// </Metalness shader>

TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_MODE = 30120,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_STRENGTH = 30130,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_BRIGHTNESS = 30140,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_CONTRAST = 30150,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_GAMMA = 30160,
TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_INVERT = 30170,

TACHYON_MATERIAL_REFLECTANCE_METALNESS_REFLECTANCE = 30180,

TACHYON_MATERIAL_REFLECTANCE_METALNESS_TEXTURE_CHANNEL_SELECTION = 30190,

//=============================================
// Properties of Reflectance - glossiness
//=============================================
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS = 31000,
TACHYON_MATERIAL_REFLECTANCE_ROUGHNESS = 31090,

// <specular-glossiness shader>
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_HREF = 31011,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_ANIM_ENABLED = 31012,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_RESOLUTION = 31013,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_USE_SRC_RES = 31014,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_SHADER_RESOLUTION_TEXT = 31015,
// </specular-glossiness shader>

TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_MODE = 31020,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_STRENGTH = 31030,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_BRIGHTNESS = 31040,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_CONTRAST = 31050,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_GAMMA = 31060,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_INVERT = 31070,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_ROUGH_SWITCH = 31080,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_MODE = 0,
TACHYON_MATERIAL_REFLECTANCE_ROUGHNESS_MODE = 1,
TACHYON_MATERIAL_REFLECTANCE_GLOSSINESS_TEXTURE_CHANNEL_SELECTION = 31100,

//=============================================
// Properties of Reflectance - reflections
//=============================================
TACHYON_MATERIAL_REFLECTANCE_REFLECTION_ENABLED = 32000,
TACHYON_MATERIAL_REFLECTANCE_REFLECTION_OVERWRITE_PHYSICAL = 32010,
TACHYON_MATERIAL_REFLECTANCE_REFLECTION_OVERWRITE_REFLECTIVITY = 32020,
TACHYON_MATERIAL_REFLECTANCE_REFLECTION_OVERWRITE_GLOSSINESS = 32030,
TACHYON_MATERIAL_REFLECTANCE_SSR_EXPOSURE = 32040,

//=============================================
// Properties of environment map
//=============================================
TACHYON_MATERIAL_ENVIRONMENT_USE_GLOBAL = 40000,
// NOTE: this is not yet ported to use a shader-link since it is currently not available in the UI !!!
TACHYON_MATERIAL_ENVIRONMENT_SHADER_HREF = 40011,
TACHYON_MATERIAL_ENVIRONMENT_ROTATION = 40020,
TACHYON_MATERIAL_ENVIRONMENT_TEXTURE_BRIGHTNESS = 40030,
TACHYON_MATERIAL_ENVIRONMENT_TEXTURE_CONTRAST = 40040,
TACHYON_MATERIAL_ENVIRONMENT_TEXTURE_GAMMA = 40050,
TACHYON_MATERIAL_ENVIRONMENT_OVERWRITE_PHYSICAL = 40060,
TACHYON_MATERIAL_ENVIRONMENT_OVERWRITE_REFLECTIVITY = 40070,
TACHYON_MATERIAL_ENVIRONMENT_OVERWRITE_GLOSSINESS = 40080,
TACHYON_MATERIAL_ENVIRONMENT_EXPOSURE = 40090,

//=============================================
// Properties of bump mapping
//=============================================
// <bump shader>
TACHYON_MATERIAL_BUMP_SHADER_HREF = 50001,
TACHYON_MATERIAL_BUMP_SHADER_ANIM_ENABLED = 50002,
TACHYON_MATERIAL_BUMP_SHADER_RESOLUTION = 50003,
TACHYON_MATERIAL_BUMP_SHADER_USE_SRC_RES = 50004,
TACHYON_MATERIAL_BUMP_SHADER_RESOLUTION_TEXT = 50005,
// </bump shader>

TACHYON_MATERIAL_BUMP_STRENGTH = 50010,
TACHYON_MATERIAL_BUMP_TEXTURE_BRIGHTNESS = 50020,
TACHYON_MATERIAL_BUMP_TEXTURE_CONTRAST = 50030,
TACHYON_MATERIAL_BUMP_TEXTURE_GAMMA = 50040,
TACHYON_MATERIAL_BUMP_TEXTURE_INVERT = 50050,
TACHYON_MATERIAL_BUMP_TEXTURE_CHANNEL_SELECTION = 50060,

TACHYON_MATERIAL_BUMP_PARALLAX_OFFSET = 50500,
TACHYON_MATERIAL_BUMP_PARALLAX_SAMPLES = 50510,


//=============================================
// Properties of normal mapping
//=============================================
// <normal shader>
TACHYON_MATERIAL_NORMAL_SHADER_HREF = 60001,
TACHYON_MATERIAL_NORMAL_SHADER_ANIM_ENABLED = 60002,
TACHYON_MATERIAL_NORMAL_SHADER_RESOLUTION = 60003,
TACHYON_MATERIAL_NORMAL_SHADER_USE_SRC_RES = 60004,
TACHYON_MATERIAL_NORMAL_SHADER_RESOLUTION_TEXT = 60005,
// </normal shader>

TACHYON_MATERIAL_NORMAL_STRENGTH = 60010,
TACHYON_MATERIAL_NORMAL_FLIP_RED = 60020,
TACHYON_MATERIAL_NORMAL_FLIP_GREEN = 60030,
TACHYON_MATERIAL_NORMAL_TEXTURE_DUMMY = 60900,

	//=============================================
	// Properties of displacement mapping
	//=============================================
	// <displacement shader>
	TACHYON_MATERIAL_DISPLACEMENT_SHADER_HREF = 70001,
	TACHYON_MATERIAL_DISPLACEMENT_SHADER_ANIM_ENABLED = 70002,
	TACHYON_MATERIAL_DISPLACEMENT_SHADER_RESOLUTION = 70003,
	TACHYON_MATERIAL_DISPLACEMENT_SHADER_USE_SRC_RES = 70004,
	TACHYON_MATERIAL_DISPLACEMENT_SHADER_RESOLUTION_TEXT = 70005,
	// </displacement shader>

	TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_STRENGTH = 70020,
	TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_BRIGHTNESS = 70030,
	TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_CONTRAST = 70040,
	TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_GAMMA = 70050,
	TACHYON_MATERIAL_DISPLACEMENT_TEXTURE_INVERT = 70060,
	TACHYON_MATERIAL_DISPLACEMENT_STRENGTH = 70100,
	TACHYON_MATERIAL_DISPLACEMENT_STEPS = 70200,
	TACHYON_MATERIAL_DISPLACEMENT_HEIGHT = 70300,
	TACHYON_MATERIAL_DISPLACEMENT_NORMAL_SMOOTHING = 70310,
	TACHYON_MATERIAL_DISPLACEMENT_TYPE = 70400,
	TACHYON_MATERIAL_DISPLACEMENT_TYPE_INTENSITY = 1,
	TACHYON_MATERIAL_DISPLACEMENT_TYPE_INTENSITY_CENTERED = 2,
	TACHYON_MATERIAL_DISPLACEMENT_TYPE_OBJECT_NORMAL = 3,
	TACHYON_MATERIAL_DISPLACEMENT_TYPE_WORLD_NORMAL = 4,
	TACHYON_MATERIAL_DISPLACEMENT_TYPE_TANGENT = 5,
	TACHYON_MATERIAL_DISPLACEMENT_TYPE_REDGREEN = 6,

	//=============================================
	// Properties of transparency
	//=============================================
	TACHYON_MATERIAL_TRANSPARENCY_AMOUNT = 80000,

	// <opacity shader>
	TACHYON_MATERIAL_OPACITY_SHADER_HREF = 80002,
	TACHYON_MATERIAL_OPACITY_SHADER_ANIM_ENABLED = 80003,
	TACHYON_MATERIAL_OPACITY_SHADER_RESOLUTION = 80004,
	TACHYON_MATERIAL_OPACITY_SHADER_USE_SRC_RES = 80005,
	TACHYON_MATERIAL_OPACITY_SHADER_RESOLUTION_TEXT = 80006,
	// </opacity shader>

	TACHYON_MATERIAL_OPACITY_TEXTURE_MODE = 80007,
	TACHYON_MATERIAL_OPACITY_TEXTURE_STRENGTH = 80008,
	TACHYON_MATERIAL_OPACITY_TEXTURE_BRIGHTNESS = 80009,
	TACHYON_MATERIAL_OPACITY_TEXTURE_CONTRAST = 80010,
	TACHYON_MATERIAL_OPACITY_TEXTURE_GAMMA = 80016,
	TACHYON_MATERIAL_OPACITY_TEXTURE_INVERT = 80017,
	TACHYON_MATERIAL_OPACITY_TEXTURE_CHANNEL_SELECTION = 80018,

	TACHYON_MATERIAL_TRANSPARENCY_TRANSMISSION_COLOR = 80001,
	// <transparency shader>
	TACHYON_MATERIAL_TRANSPARENCY_SHADER_HREF = 80011,
	TACHYON_MATERIAL_TRANSPARENCY_SHADER_ANIM_ENABLED = 80012,
	TACHYON_MATERIAL_TRANSPARENCY_SHADER_RESOLUTION = 80013,
	TACHYON_MATERIAL_TRANSPARENCY_SHADER_USE_SRC_RES = 80014,
	TACHYON_MATERIAL_TRANSPARENCY_SHADER_RESOLUTION_TEXT = 80015,
	// </transparency shader>

	TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_MODE = 80020,
	TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_STRENGTH = 80030,
	TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_BRIGHTNESS = 80040,
	TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_CONTRAST = 80050,
	TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_GAMMA = 80060,
	TACHYON_MATERIAL_TRANSPARENCY_TEXTURE_INVERT = 80070,

	TACHYON_MATERIAL_TRANSPARENCY_CAST_SHADOW = 80080,
	TACHYON_MATERIAL_TRANSPARENCY_IOR = 80090,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS = 80100,
	TACHYON_MATERIAL_TRANSMISSIVE_APPLY_OPACITY = 80101,

	// <transparency-blurriness shader>
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_HREF = 80201,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_ANIM_ENABLED = 80202,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_RESOLUTION = 80203,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_USE_SRC_RES = 80204,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_SHADER_RESOLUTION_TEXT = 80205,
	// </transparency-blurriness shader>

	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_MODE = 80210,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_GAMMA = 80220,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_STRENGTH = 80230,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_BRIGHTNESS = 80240,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_CONTRAST = 80250,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_INVERT = 80260,
	TACHYON_MATERIAL_TRANSPARENCY_BLURRINESS_TEXTURE_CHANNEL_SELECTION = 80270,

	//=============================================
	// Properties of Emissive 
	//=============================================
	TACHYON_MATERIAL_EMISSIVE_BRIGHTNESS = 90000,
	TACHYON_MATERIAL_EMISSIVE_COLOR = 90080,

	// <emissive shader>
	TACHYON_MATERIAL_EMISSIVE_SHADER_HREF = 90011,
	TACHYON_MATERIAL_EMISSIVE_SHADER_ANIM_ENABLED = 90012,
	TACHYON_MATERIAL_EMISSIVE_SHADER_RESOLUTION = 90013,
	TACHYON_MATERIAL_EMISSIVE_SHADER_USE_SRC_RES = 90014,
	TACHYON_MATERIAL_EMISSIVE_SHADER_RESOLUTION_TEXT = 90015,
	// </emissive shader>

	TACHYON_MATERIAL_EMISSIVE_TEXTURE_MODE = 90060,
	TACHYON_MATERIAL_EMISSIVE_TEXTURE_STRENGTH = 90070,
	TACHYON_MATERIAL_EMISSIVE_TEXTURE_BRIGHTNESS = 90020,
	TACHYON_MATERIAL_EMISSIVE_TEXTURE_CONTRAST = 90030,
	TACHYON_MATERIAL_EMISSIVE_TEXTURE_GAMMA = 90040,
	TACHYON_MATERIAL_EMISSIVE_TEXTURE_INVERT = 90050,

	// =============================================
	// Properties of Matte
	// =============================================
	TACHYON_MATERIAL_MASK_THRESHOLD = 100001,
	TACHYON_MATERIAL_MASK_CHANNEL_SELECTION = 100002,
		TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_RED = 1,
		TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_GREEN = 2,
		TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_BLUE = 3,
		TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_ALPHA = 4,
		TACHYON_MATERIAL_TEXTURE_CHANNEL_SELECT_LUMINANCE = 5,

	// <mask shader>
	TACHYON_MATERIAL_MASK_SHADER_HREF = 100010,
	TACHYON_MATERIAL_MASK_SHADER_ANIM_ENABLED = 100011,
	TACHYON_MATERIAL_MASK_SHADER_RESOLUTION = 100012,
	TACHYON_MATERIAL_MASK_SHADER_USE_SRC_RES = 100013,
	TACHYON_MATERIAL_MASK_SHADER_RESOLUTION_TEXT = 100014,
	// </mask shader>

	TACHYON_MATERIAL_MASK_TEXTURE_BRIGHTNESS = 100020,
	TACHYON_MATERIAL_MASK_TEXTURE_CONTRAST = 100021,
	TACHYON_MATERIAL_MASK_TEXTURE_GAMMA = 100022,
	TACHYON_MATERIAL_MASK_TEXTURE_INVERT = 100023,

	// ====================================================
	// Properties of Clear Coat
	// ====================================================
	TACHYON_MATERIAL_CLEARCOAT_STRENGTH = 110010,
	TACHYON_MATERIAL_CLEARCOAT_BASE_NORMAL_STRENGTH = 110020,

	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_ROUGH_SWITCH = 110100,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS = 110110,
	TACHYON_MATERIAL_CLEARCOAT_ROUGHNESS = 110120,

	// <specular-glossiness shader>
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_HREF = 110200,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_ANIM_ENABLED = 110210,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_RESOLUTION = 110220,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_USE_SRC_RES = 110230,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_SHADER_RESOLUTION_TEXT = 110240,
	// </specular-glossiness shader>

	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_MODE = 110300,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_CHANNEL_SELECTION = 110310,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_STRENGTH = 110320,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_BRIGHTNESS = 110330,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_CONTRAST = 110340,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_GAMMA = 110350,
	TACHYON_MATERIAL_CLEARCOAT_GLOSSINESS_TEXTURE_INVERT = 110360,

    TACHYON_MATERIAL_CLEARCOAT_NORMAL_STRENGTH = 110400,
    TACHYON_MATERIAL_CLEARCOAT_NORMAL_FLIP_RED = 110410,
    TACHYON_MATERIAL_CLEARCOAT_NORMAL_FLIP_GREEN = 110420,
    TACHYON_MATERIAL_CLEARCOAT_NORMAL_TEXTURE_DUMMY = 110430,
    TACHYON_MATERIAL_CLEARCOAT_NORMAL_BLEND = 110440,

	// <normal shader>
	TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_HREF = 110500,
	TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_ANIM_ENABLED = 110510,
	TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_RESOLUTION = 110520,
	TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_USE_SRC_RES = 110530,
	TACHYON_MATERIAL_CLEARCOAT_NORMAL_SHADER_RESOLUTION_TEXT = 110540,
	// </normal shader>
};

#endif
